/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Arrays;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Reader;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.socket.impl.SocketHandlerFunction;
import net.skinsrestorer.shadow.mariadb.client.socket.impl.SocketUtility;
import net.skinsrestorer.shadow.mariadb.export.SslMode;
import net.skinsrestorer.shadow.mariadb.message.client.SslRequestPacket;
import net.skinsrestorer.shadow.mariadb.message.server.AuthSwitchPacket;
import net.skinsrestorer.shadow.mariadb.message.server.ErrorPacket;
import net.skinsrestorer.shadow.mariadb.message.server.InitialHandshakePacket;
import net.skinsrestorer.shadow.mariadb.plugin.AuthenticationPlugin;
import net.skinsrestorer.shadow.mariadb.plugin.Credential;
import net.skinsrestorer.shadow.mariadb.plugin.CredentialPlugin;
import net.skinsrestorer.shadow.mariadb.plugin.TlsSocketPlugin;
import net.skinsrestorer.shadow.mariadb.plugin.authentication.AuthenticationPluginLoader;
import net.skinsrestorer.shadow.mariadb.plugin.tls.TlsSocketPluginLoader;
import net.skinsrestorer.shadow.mariadb.util.ConfigurableSocketFactory;

public final class ConnectionHelper {
    private static final SocketHandlerFunction socketHandler;

    public static Socket createSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        return socketHandler.apply(conf, hostAddress);
    }

    public static Socket standardSocket(Configuration conf, HostAddress hostAddress) throws IOException, SQLException {
        String socketFactoryName = conf.socketFactory();
        if (socketFactoryName != null) {
            if (hostAddress == null) {
                throw new SQLException("hostname must be set to connect socket");
            }
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName);
                Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                if (socketFactory instanceof ConfigurableSocketFactory) {
                    ((ConfigurableSocketFactory)socketFactory).setConfiguration(conf, hostAddress.host);
                }
                return socketFactory.createSocket();
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + conf.socketFactory() + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static Socket connectSocket(Configuration conf, HostAddress hostAddress) throws SQLException {
        try {
            if (conf.pipe() == null && conf.localSocket() == null && hostAddress == null) {
                throw new SQLException("hostname must be set to connect socket if not using local socket or pipe");
            }
            Socket socket = ConnectionHelper.createSocket(conf, hostAddress);
            ConnectionHelper.setSocketOption(conf, socket);
            if (!socket.isConnected()) {
                InetSocketAddress sockAddr = conf.pipe() == null && conf.localSocket() == null ? new InetSocketAddress(hostAddress.host, hostAddress.port) : null;
                socket.connect(sockAddr, conf.connectTimeout());
            }
            return socket;
        }
        catch (IOException ioe) {
            throw new SQLNonTransientConnectionException(String.format("Socket fail to connect to host:%s. %s", hostAddress == null ? conf.localSocket() : hostAddress, ioe.getMessage()), "08000", ioe);
        }
    }

    public static void setSocketOption(Configuration conf, Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(conf.socketTimeout());
        if (conf.tcpKeepAlive()) {
            socket.setKeepAlive(true);
        }
        if (conf.tcpAbortiveClose()) {
            socket.setSoLinger(true, 0);
        }
        if (conf.localSocketAddress() != null) {
            InetSocketAddress localAddress = new InetSocketAddress(conf.localSocketAddress(), 0);
            socket.bind(localAddress);
        }
    }

    public static long initializeClientCapabilities(Configuration configuration, long serverCapabilities) {
        boolean deprecateEof;
        long capabilities = 34372231936L;
        if (configuration.useServerPrepStmts() && Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("enableSkipMeta", "true"))) {
            capabilities |= 0x1000000000L;
        }
        if (Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("interactiveClient", "false"))) {
            capabilities |= 0x400L;
        }
        if (configuration.useBulkStmts()) {
            capabilities |= 0x400000000L;
        }
        if (!configuration.useAffectedRows()) {
            capabilities |= 2L;
        }
        if (configuration.allowMultiQueries()) {
            capabilities |= 0x10000L;
        }
        if (configuration.allowLocalInfile()) {
            capabilities |= 0x80L;
        }
        if (deprecateEof = Boolean.parseBoolean(configuration.nonMappedOptions().getProperty("deprecateEof", "true"))) {
            capabilities |= 0x1000000L;
        }
        if (configuration.useCompression()) {
            capabilities |= 0x20L;
        }
        if (configuration.database() != null && !configuration.createDatabaseIfNotExist()) {
            capabilities |= 8L;
        }
        return capabilities & serverCapabilities;
    }

    public static byte decideLanguage(InitialHandshakePacket handshake) {
        int serverLanguage = handshake.getDefaultCollation();
        return (byte)(serverLanguage == 45 || serverLanguage == 46 || serverLanguage >= 224 && serverLanguage <= 247 ? serverLanguage : 224);
    }

    public static void authenticationHandler(Credential credential, Writer writer, Reader reader, Context context) throws IOException, SQLException {
        writer.permitTrace(true);
        Configuration conf = context.getConf();
        ReadableByteBuf buf = reader.readPacket(false);
        block5: while (true) {
            switch (buf.getByte() & 0xFF) {
                case 254: {
                    AuthSwitchPacket authSwitchPacket = AuthSwitchPacket.decode(buf);
                    AuthenticationPlugin authenticationPlugin = AuthenticationPluginLoader.get(authSwitchPacket.getPlugin(), conf);
                    authenticationPlugin.initialize(credential.getPassword(), authSwitchPacket.getSeed(), conf);
                    buf = authenticationPlugin.process(writer, reader, context);
                    continue block5;
                }
                case 255: {
                    ErrorPacket errorPacket = new ErrorPacket(buf, context);
                    throw context.getExceptionFactory().create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode());
                }
                case 0: {
                    buf.skip();
                    buf.readLongLengthEncodedNotNull();
                    buf.readLongLengthEncodedNotNull();
                    context.setServerStatus(buf.readShort());
                    break block5;
                }
                default: {
                    throw context.getExceptionFactory().create("unexpected data during authentication (header=" + buf.getUnsignedByte(), "08000");
                }
            }
            break;
        }
        writer.permitTrace(true);
    }

    public static Credential loadCredential(CredentialPlugin credentialPlugin, Configuration configuration, HostAddress hostAddress) throws SQLException {
        if (credentialPlugin != null) {
            return (Credential)credentialPlugin.initialize(configuration, configuration.user(), hostAddress).get();
        }
        return new Credential(configuration.user(), configuration.password());
    }

    public static SSLSocket sslWrapper(HostAddress hostAddress, Socket socket, long clientCapabilities, byte exchangeCharset, Context context, Writer writer) throws IOException, SQLException {
        Configuration conf = context.getConf();
        if (conf.sslMode() != SslMode.DISABLE) {
            if (!context.hasServerCapability(2048L)) {
                throw context.getExceptionFactory().create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SslRequestPacket.create(clientCapabilities |= 0x800L, exchangeCharset).encode(writer, context);
            TlsSocketPlugin socketPlugin = TlsSocketPluginLoader.get(conf.tlsSocketType());
            SSLSocketFactory sslSocketFactory = socketPlugin.getSocketFactory(conf, context.getExceptionFactory());
            SSLSocket sslSocket = socketPlugin.createSocket(socket, sslSocketFactory);
            ConnectionHelper.enabledSslProtocolSuites(sslSocket, conf);
            ConnectionHelper.enabledSslCipherSuites(sslSocket, conf);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            if (conf.sslMode() == SslMode.VERIFY_FULL && hostAddress != null) {
                SSLSession session = sslSocket.getSession();
                try {
                    socketPlugin.verify(hostAddress.host, session, context.getThreadId());
                }
                catch (SSLException ex) {
                    throw context.getExceptionFactory().create("SSL hostname verification failed : " + ex.getMessage() + "\nThis verification can be disabled using the sslMode to VERIFY_CA but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            return sslSocket;
        }
        return null;
    }

    static void enabledSslProtocolSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslProtocolSuites() != null) {
            String[] protocols;
            List<String> possibleProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
            for (String protocol : protocols = conf.enabledSslProtocolSuites().split("[,;\\s]+")) {
                if (possibleProtocols.contains(protocol)) continue;
                throw new SQLException("Unsupported SSL protocol '" + protocol + "'. Supported protocols : " + possibleProtocols.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    static void enabledSslCipherSuites(SSLSocket sslSocket, Configuration conf) throws SQLException {
        if (conf.enabledSslCipherSuites() != null) {
            String[] ciphers;
            List<String> possibleCiphers = Arrays.asList(sslSocket.getSupportedCipherSuites());
            for (String cipher : ciphers = conf.enabledSslCipherSuites().split("[,;\\s]+")) {
                if (possibleCiphers.contains(cipher)) continue;
                throw new SQLException("Unsupported SSL cipher '" + cipher + "'. Supported ciphers : " + possibleCiphers.toString().replace("[", "").replace("]", ""));
            }
            sslSocket.setEnabledCipherSuites(ciphers);
        }
    }

    static {
        SocketHandlerFunction init;
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            init = ConnectionHelper::standardSocket;
        }
        socketHandler = init;
    }
}

